<?php

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>صفحه پیدا نشد - 404</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;700&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Vazirmatn', sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            color: #fff;
            overflow: hidden;
        }
        
        .container {
            text-align: center;
            position: relative;
            z-index: 1;
        }
        
        .error-code {
            font-size: 150px;
            font-weight: 700;
            position: relative;
            animation: bounce 2s infinite alternate;
        }
        
        .error-code span {
            display: inline-block;
        }
        
        .error-code span:nth-child(1) {
            animation: float 3s ease-in-out infinite;
        }
        
        .error-code span:nth-child(2) {
            animation: float 3s ease-in-out infinite 0.5s;
        }
        
        .error-code span:nth-child(3) {
            animation: float 3s ease-in-out infinite 1s;
        }
        
        .error-message {
            font-size: 24px;
            margin: 20px 0;
            animation: fadeIn 1.5s ease-in-out;
        }
        
        .home-btn {
            display: inline-block;
            padding: 12px 30px;
            background: #fff;
            color: #764ba2;
            text-decoration: none;
            border-radius: 30px;
            font-weight: 700;
            margin-top: 20px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
            animation: pulse 2s infinite;
        }
        
        .home-btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.3);
        }
        
        .astronaut {
            position: absolute;
            width: 150px;
            animation: float 6s ease-in-out infinite;
        }
        
        .astronaut-1 {
            top: 10%;
            left: 10%;
        }
        
        .astronaut-2 {
            bottom: 10%;
            right: 10%;
            animation-delay: 1s;
        }
        
        .stars {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
        }
        
        .star {
            position: absolute;
            background-color: #fff;
            border-radius: 50%;
            animation: twinkle 2s infinite;
        }
        
        @keyframes bounce {
            0% {
                transform: translateY(0);
            }
            100% {
                transform: translateY(-20px);
            }
        }
        
        @keyframes float {
            0% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-20px);
            }
            100% {
                transform: translateY(0);
            }
        }
        
        @keyframes fadeIn {
            0% {
                opacity: 0;
                transform: translateY(20px);
            }
            100% {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes pulse {
            0% {
                transform: scale(1);
            }
            50% {
                transform: scale(1.05);
            }
            100% {
                transform: scale(1);
            }
        }
        
        @keyframes twinkle {
            0% {
                opacity: 0.2;
            }
            50% {
                opacity: 1;
            }
            100% {
                opacity: 0.2;
            }
        }
        

        .stars {
            pointer-events: none;
        }
    </style>
</head>
<body>
    <div class="stars" id="stars"></div>
    
    
    
    <div class="container">
        <div class="error-code">
            <span>4</span>
            <span>0</span>
            <span>4</span>
        </div>
        <h1 class="error-message">صفحه مورد نظر یافت نشد!</h1>
        <p>به نظر می‌رسد صفحه‌ای که به دنبال آن هستید وجود ندارد یا حذف شده است.</p>
        <a href="#" class="home-btn">بازگشت به صفحه اصلی</a>
    </div>

    <script>

        const starsContainer = document.getElementById('stars');
        const starCount = 100;
        
        for (let i = 0; i < starCount; i++) {
            const star = document.createElement('div');
            star.classList.add('star');
            

            const size = Math.random() * 2 + 1;
            star.style.width = `${size}px`;
            star.style.height = `${size}px`;
            

            star.style.left = `${Math.random() * 100}%`;
            star.style.top = `${Math.random() * 100}%`;
            

            star.style.animationDelay = `${Math.random() * 2}s`;
            
            starsContainer.appendChild(star);
        }
    </script>
</body>
</html>
